<?php
/**
 * All Notice facing functions
 */
namespace codexpert\Woolementor;

/**
 * if accessed directly, exit.
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * @package Plugin
 * @subpackage Notice
 * @author codexpert <hello@codexpert.io>
 */
class Notice extends Hooks {
	
	public $slug;
	public $name;

	public function __construct( $plugin ) {

		$this->plugin 	= $plugin;

		$this->server 	= $this->plugin['Server'];
		$this->slug 	= $this->plugin['TextDomain'];
		$this->name 	= $this->plugin['Name'];
		
		self::hooks();
	}

	public function hooks(){
		add_action( 'admin_notices', array( $this, 'admin_notices' ) );
		add_action( 'wp_ajax_cx-dismiss', array( $this, 'dismiss_notices' ) );
	}

	public function admin_notices() {
		/**
		 * Remote notices
		 */
		$endpoint = "{$this->server}/wp-json/notices/latest?plugin={$this->slug}&count=2";
		if( apply_filters( "cx-plugin_remote_notice_endpoint", $endpoint, $this->slug ) ) : // return false to disable

			if( false == ( $notices = wp_cache_get( $this->slug, 'cx-plugin-notices' ) ) ) {
				$response = wp_remote_get( $endpoint );
				
				$notices = [];
				if( wp_remote_retrieve_response_code( $response ) == 200 ) :
					$notices = json_decode( wp_remote_retrieve_body( $response ) );
				endif;

				wp_cache_set( $this->slug, $notices, 'cx-plugin-notices', HOUR_IN_SECONDS );
			}

			if( is_array( $notices ) && count( $notices ) > 0 ) :
			$ajax_url = admin_url( 'admin-ajax.php' );
			foreach ( $notices as $notice ) {
				if( false == get_option( "_notice-{$this->slug}-{$notice->id}" ) ) :
				$dismiss_url = add_query_arg( [ 'action' => 'cx-dismiss', 'plugin' => $this->slug, 'notice' => $notice->id ], $ajax_url );
				echo "
				<div id='notice-{$this->slug}-{$notice->id}' class='notice cx-notice cx-plugin-notice is-dismissible' data-id='{$notice->id}' data-dismiss-url='{$dismiss_url}'>
					<a href='{$notice->link}' target='_blank'><img src='{$notice->image}' /></a>
				</div>";
				endif;
			}
			endif;

		endif; //if( apply_filters( "cx-plugin_remote_notice_endpoint" ) ) :
	}

	public function dismiss_notices() {
		update_option( "_notice-{$_GET['plugin']}-{$_GET['notice']}", time(), false );
		wp_die( __( 'Dismissed' ) );
	}

	public function action_links( $plugin, $action = '' ) {

		$exploded	= explode( '/', $plugin );
		$slug		= $exploded[0];

		$links = [
			'install'		=> wp_nonce_url( admin_url( "update.php?action=install-plugin&plugin={$slug}" ), "install-plugin_{$slug}" ),
			'update'		=> wp_nonce_url( admin_url( "update.php?action=upgrade-plugin&plugin={$plugin}" ), "upgrade-plugin_{$plugin}" ),
			'activate'		=> wp_nonce_url( admin_url( "plugins.php?action=activate&plugin={$plugin}&plugin_status=all&paged=1&s" ), "activate-plugin_{$plugin}" ),
			'deactivate'	=> wp_nonce_url( admin_url( "plugins.php?action=deactivate&plugin={$plugin}&plugin_status=all&paged=1&s" ), "deactivate-plugin_{$plugin}" ),
		];

		if( $action != '' && array_key_exists( $action, $links ) ) return $links[ $action ];

		return $links;
	}
}